/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ametys.runtime.log.MemoryLogRecord;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class MemoryAppender
extends AppenderSkeleton {
    private static final long __LOG_EXPIRATION_TIME = 600000L;
    private static final long __TIME_DURATION_BEFORE_NEXT_CLEAN = 10000L;
    private long _lastCleanTime;
    private LinkedList<MemoryLogRecord> _logsQueue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        MemoryLogRecord record = new MemoryLogRecord();
        record.setCategory(event.getLoggerName());
        record.setMessage(event.getRenderedMessage());
        record.setLocation(event.getLocationInformation().fullInfo);
        record.setMillis(event.timeStamp);
        record.setUser((String)event.getMDC("user"));
        record.setRequestURI((String)event.getMDC("requestURI"));
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        if (throwableInformation != null) {
            record.setThrownStackTrace(throwableInformation);
        }
        try {
            String level = event.getLevel().toString();
            record.setLevel(LogLevel.valueOf((String)level));
        }
        catch (LogLevelFormatException e) {
            record.setLevel(LogLevel.WARN);
        }
        this.removeExpiredEvents(System.currentTimeMillis() - 600000L);
        LinkedList<MemoryLogRecord> linkedList = this._logsQueue;
        synchronized (linkedList) {
            this._logsQueue.add(record);
        }
    }

    public List<MemoryLogRecord> getEvents(long fromTimestamp) {
        return this.getEvents(fromTimestamp, Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemoryLogRecord> getEvents(long fromTimestamp, List<String> filterCategories) {
        long toTimestamp = System.currentTimeMillis() - 1L;
        LinkedList<MemoryLogRecord> linkedList = this._logsQueue;
        synchronized (linkedList) {
            if (fromTimestamp <= 0L && filterCategories.isEmpty()) {
                return new ArrayList<MemoryLogRecord>(this._logsQueue);
            }
            if (toTimestamp < fromTimestamp) {
                return new ArrayList<MemoryLogRecord>();
            }
            ArrayList<MemoryLogRecord> recentRecords = new ArrayList<MemoryLogRecord>();
            Iterator<MemoryLogRecord> it = this._logsQueue.descendingIterator();
            while (it.hasNext()) {
                MemoryLogRecord record = it.next();
                if (fromTimestamp > 0L && record.getMillis() < fromTimestamp || record.getMillis() > toTimestamp) break;
                if (!this._matchCategoryFilter(filterCategories, record)) continue;
                recentRecords.add(record);
            }
            return recentRecords;
        }
    }

    private boolean _matchCategoryFilter(List<String> filterCategories, MemoryLogRecord record) {
        String recordCategory = record.getCategory();
        if (filterCategories.isEmpty() || filterCategories.contains(recordCategory)) {
            return true;
        }
        for (String category : filterCategories) {
            if (!recordCategory.startsWith(category.concat("."))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredEvents(long from) {
        LinkedList<MemoryLogRecord> linkedList = this._logsQueue;
        synchronized (linkedList) {
            if (this._lastCleanTime != 0L && this._lastCleanTime + 10000L > System.currentTimeMillis()) {
                return;
            }
            MemoryLogRecord record = this._logsQueue.peek();
            while (record != null && record.getMillis() < from) {
                this._logsQueue.remove();
                record = this._logsQueue.peek();
            }
            this._lastCleanTime = System.currentTimeMillis();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
        this._logsQueue.clear();
    }
}

