/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.runtime.config.DisableCondition;
import org.ametys.runtime.config.DisableConditions;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractModelItemParser;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementDefinitionParser
extends AbstractModelItemParser {
    private static final Logger __LOGGER = LoggerFactory.getLogger(ElementDefinitionParser.class);
    private AbstractThreadSafeComponentExtensionPoint<? extends ElementType> _elementTypeExtensionPoint;
    private ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    private ThreadSafeComponentManager<Validator> _validatorManager;
    private final Map<ElementDefinition, String> _validatorsToLookup = new HashMap<ElementDefinition, String>();
    private final Map<ElementDefinition, String> _enumeratorsToLookup = new HashMap<ElementDefinition, String>();

    public ElementDefinitionParser(AbstractThreadSafeComponentExtensionPoint<? extends ElementType> elementTypeExtensionPoint, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
        this._elementTypeExtensionPoint = elementTypeExtensionPoint;
        this._enumeratorManager = enumeratorManager;
        this._validatorManager = validatorManager;
    }

    @Override
    public ElementDefinition parse(ServiceManager serviceManager, String pluginName, Configuration definitionConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        ElementDefinition definition = (ElementDefinition)super.parse(serviceManager, pluginName, definitionConfig, model, parent);
        definition.setPluginName(pluginName);
        definition.setType(this._parseType(definitionConfig));
        definition.setDefaultValue(this._parseDefaultValue(definitionConfig, definition));
        definition.setMultiple(this._parseMultiple(definitionConfig));
        definition.setWidget(this._parseWidget(definitionConfig));
        definition.setWidgetParameters(this._parseWidgetParameters(definitionConfig, pluginName));
        this._parseAndSetEnumerator(pluginName, definition, definitionConfig);
        this._parseAndSetValidator(pluginName, definition, definitionConfig);
        definition.setDisableConditions(this._parseDisableConditions(definitionConfig));
        return definition;
    }

    @Override
    protected ElementDefinition _createModelItem(Configuration definitionConfig) throws ConfigurationException {
        return new ElementDefinition();
    }

    protected Object _parseDefaultValue(Configuration definitionConfig, ElementDefinition definition) throws ConfigurationException {
        Configuration childNode = definitionConfig.getChild("default-value", false);
        if (childNode != null) {
            return definition.getType().parseConfiguration(childNode);
        }
        return null;
    }

    protected ElementType _parseType(Configuration definitionConfig) throws ConfigurationException {
        String typeId = definitionConfig.getAttribute("type");
        if (!this._elementTypeExtensionPoint.hasExtension(typeId)) {
            String elementName = this._parseName(definitionConfig);
            throw new ConfigurationException("Unable to find the type '" + typeId + "' defined on the element '" + elementName + "'.");
        }
        return this._elementTypeExtensionPoint.getExtension(typeId);
    }

    protected Boolean _parseMultiple(Configuration definitionConfig) throws ConfigurationException {
        return definitionConfig.getAttributeAsBoolean("multiple", false);
    }

    protected String _parseWidget(Configuration definitionConfig) throws ConfigurationException {
        return definitionConfig.getChild("widget").getValue(null);
    }

    protected Map<String, I18nizableText> _parseWidgetParameters(Configuration definitionConfig, String pluginName) throws ConfigurationException {
        HashMap<String, I18nizableText> widgetParams = new HashMap<String, I18nizableText>();
        Configuration widgetParamsConfig = definitionConfig.getChild("widget-params", false);
        if (widgetParamsConfig != null) {
            Map<String, Object> parsedParams = ConfigurationHelper.parsePluginParameters(widgetParamsConfig, pluginName, __LOGGER);
            for (Map.Entry<String, Object> param : parsedParams.entrySet()) {
                String paramName = param.getKey();
                Object value = param.getValue();
                if (value instanceof I18nizableText) {
                    widgetParams.put(paramName, (I18nizableText)value);
                    continue;
                }
                if (value instanceof String) {
                    widgetParams.put(paramName, new I18nizableText((String)value));
                    continue;
                }
                __LOGGER.warn("Widget parameter '{}' at location {} is of type [{}] which is not supported. It will be ignored.", new Object[]{paramName, definitionConfig.getLocation(), value.getClass()});
            }
        }
        return widgetParams;
    }

    protected void _parseAndSetEnumerator(String pluginName, ElementDefinition definition, Configuration definitionConfig) throws ConfigurationException {
        Configuration enumeratorConfig = definitionConfig.getChild("enumeration", false);
        if (enumeratorConfig != null) {
            Configuration customEnumerator = enumeratorConfig.getChild("custom-enumerator", false);
            if (customEnumerator != null) {
                String enumeratorClassName = customEnumerator.getAttribute("class");
                String enumeratorRole = definition.getPath();
                try {
                    Class<?> enumeratorClass = Class.forName(enumeratorClassName);
                    this._enumeratorManager.addComponent(pluginName, null, enumeratorRole, enumeratorClass, definitionConfig);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to instantiate enumerator for class: " + enumeratorClassName, (Throwable)e);
                }
                this._enumeratorsToLookup.put(definition, enumeratorRole);
            } else {
                StaticEnumerator staticEnumerator = new StaticEnumerator();
                for (Configuration entryConfig : enumeratorConfig.getChildren("entry")) {
                    Configuration valueConfiguration = entryConfig.getChild("value");
                    Object value = definition.getType().parseConfiguration(valueConfiguration);
                    I18nizableText label = null;
                    if (entryConfig.getChild("label", false) != null) {
                        label = this._parseI18nizableText(entryConfig, pluginName, "label");
                    }
                    staticEnumerator.add(label, value);
                }
                definition.setEnumerator(staticEnumerator);
            }
        }
    }

    protected void _parseAndSetValidator(String pluginName, ElementDefinition definition, Configuration definitionConfig) throws ConfigurationException {
        Configuration validatorConfig = definitionConfig.getChild("validation", false);
        if (validatorConfig != null) {
            String validatorClassName = (String)StringUtils.defaultIfBlank((CharSequence)validatorConfig.getChild("custom-validator").getAttribute("class", ""), (CharSequence)DefaultValidator.class.getName());
            String validatorRole = definition.getPath();
            try {
                Class<?> validatorClass = Class.forName(validatorClassName);
                this._validatorManager.addComponent(pluginName, null, validatorRole, validatorClass, definitionConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate validator for class: " + validatorClassName, (Throwable)e);
            }
            this._validatorsToLookup.put(definition, validatorRole);
        }
    }

    protected DisableConditions _parseDisableConditions(Configuration definitionConfiguration) throws ConfigurationException {
        Configuration disableConditionConfiguration = definitionConfiguration.getChild("disable-conditions", false);
        DisableConditions conditions = null;
        if (disableConditionConfiguration != null) {
            Configuration[] conditionsConfiguration;
            conditions = new DisableConditions();
            for (Configuration conditionConfiguration : conditionsConfiguration = disableConditionConfiguration.getChildren()) {
                String tagName = conditionConfiguration.getName();
                if (tagName.equals("conditions")) {
                    conditions.getSubConditions().add(this._parseDisableConditions(conditionConfiguration));
                    continue;
                }
                if (!tagName.equals("condition")) continue;
                String id = conditionConfiguration.getAttribute("id");
                DisableCondition.OPERATOR operator = DisableCondition.OPERATOR.valueOf(conditionConfiguration.getAttribute("operator", "eq").toUpperCase());
                String value = conditionConfiguration.getValue("");
                DisableCondition condition = new DisableCondition(id, operator, value);
                conditions.getConditions().add(condition);
            }
            conditions.setAssociation(DisableConditions.ASSOCIATION_TYPE.valueOf(disableConditionConfiguration.getAttribute("type", "and").toUpperCase()));
        }
        return conditions;
    }

    public void lookupComponents() throws Exception {
        ElementDefinition definition;
        this._validatorManager.initialize();
        this._enumeratorManager.initialize();
        for (Map.Entry<ElementDefinition, String> entry : this._validatorsToLookup.entrySet()) {
            definition = entry.getKey();
            String validatorRole = entry.getValue();
            try {
                definition.setValidator(this._validatorManager.lookup(validatorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup validator role: '" + validatorRole + "' for parameter: " + definition, e);
            }
        }
        for (Map.Entry<ElementDefinition, String> entry : this._enumeratorsToLookup.entrySet()) {
            definition = entry.getKey();
            String enumeratorRole = entry.getValue();
            try {
                definition.setEnumerator(this._enumeratorManager.lookup(enumeratorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup enumerator role: '" + enumeratorRole + "' for parameter: " + definition, e);
            }
        }
    }
}

