/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.config.ConfigParameterInfo;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.apache.avalon.framework.configuration.Configuration;

public class Plugin {
    private String _pluginName;
    private Configuration _configuration;
    private Map<String, ConfigParameterInfo> _configParameters = new HashMap<String, ConfigParameterInfo>();
    private Map<String, ConfigParameterInfo> _paramCheckers = new HashMap<String, ConfigParameterInfo>();
    private Map<String, Feature> _features = new HashMap<String, Feature>();
    private Map<String, ExtensionPointDefinition> _extensionPoints = new HashMap<String, ExtensionPointDefinition>();

    Plugin(String pluginName) {
        this._pluginName = pluginName;
    }

    public String getName() {
        return this._pluginName;
    }

    public Map<String, Feature> getFeatures() {
        return this._features;
    }

    public Collection<String> getExtensionPoints() {
        return Collections.unmodifiableSet(this._extensionPoints.keySet());
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    Map<String, ExtensionPointDefinition> getExtensionPointDefinitions() {
        return this._extensionPoints;
    }

    Map<String, ConfigParameterInfo> getConfigParameters() {
        return this._configParameters;
    }

    Map<String, ConfigParameterInfo> getParameterCheckers() {
        return this._paramCheckers;
    }

    void configure(Configuration configuration) {
        this._configuration = configuration;
        Configuration configConfiguration = configuration.getChild("config");
        this._configureConfigParameters(configConfiguration);
        this._configureParametersCheckers(configConfiguration);
        this._configureFeatures();
        this._configureExtensionPoints();
    }

    private void _configureConfigParameters(Configuration configConfiguration) {
        Configuration[] parameterConfigurations;
        for (Configuration parameterConfiguration : parameterConfigurations = configConfiguration.getChildren("param")) {
            String id = parameterConfiguration.getAttribute("id", null);
            this._configParameters.put(id, new ConfigParameterInfo(id, this._pluginName, parameterConfiguration));
        }
    }

    private void _configureParametersCheckers(Configuration configConfiguration) {
        Configuration[] parameterConfigurations;
        for (Configuration parameterConfiguration : parameterConfigurations = configConfiguration.getChildren("param-checker")) {
            String id = parameterConfiguration.getAttribute("id", null);
            this._paramCheckers.put(id, new ConfigParameterInfo(id, this._pluginName, parameterConfiguration));
        }
    }

    private void _configureFeatures() {
        Configuration[] featuresConf;
        for (Configuration conf : featuresConf = this._configuration.getChildren("feature")) {
            String featureName = conf.getAttribute("name", null);
            Feature feature = new Feature(this._pluginName, featureName);
            feature.configure(conf);
            this._features.put(feature.getFeatureId(), feature);
        }
    }

    private void _configureExtensionPoints() {
        Configuration[] extPointConfs;
        for (Configuration conf : extPointConfs = this._configuration.getChild("extension-points").getChildren("extension-point")) {
            String id = conf.getAttribute("id", null);
            boolean safe = conf.getAttributeAsBoolean("safe", false);
            this._extensionPoints.put(id, new ExtensionPointDefinition(id, conf, this._pluginName, safe));
        }
    }
}

