/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.config.ConfigParameterTypeExtensionPoint;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.ExcludePolicyFeatureActivator;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.IncludePolicyFeatureActivator;
import org.ametys.runtime.plugin.Init;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginException;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.component.PluginsComponentManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

public final class PluginsManager {
    public static final String PLUGIN_NAMES_IGNORED = "^CVS|\\..+|.*\\.bak|.*\\.old$";
    public static final String PLUGIN_NAME_REGEXP = "[a-zA-Z0-9](?:[a-zA-Z0-9-_\\.]*[a-zA-Z0-9])?";
    public static final String FEATURE_ID_SEPARATOR = "/";
    public static final String PLUGIN_FILENAME = "plugin.xml";
    public static final String INCLUDED_FEATURES_CONTEXT_ATTRIBUTE = IncludePolicyFeatureActivator.IncludedFeature.class.getName();
    private static PluginsManager __instance;
    private boolean _safeMode;
    private Map<String, String> _resourceURIs;
    private Map<String, File> _locations;
    private Map<String, Plugin> _allPlugins;
    private Map<String, Plugin> _plugins;
    private Map<String, Feature> _features;
    private Map<String, InactivityCause> _inactiveFeatures;
    private Map<String, ExtensionPointDefinition> _extensionPoints;
    private Map<String, ComponentDefinition> _components;
    private Map<String, Map<String, ExtensionDefinition>> _extensions;
    private Status _status;
    private Logger _logger = LoggerFactory.getLogger(PluginsManager.class);
    private Collection<PluginIssue> _errors = new ArrayList<PluginIssue>();
    private FeatureActivator _featureActivator;

    private PluginsManager() {
    }

    public static PluginsManager getInstance() {
        if (__instance == null) {
            __instance = new PluginsManager();
        }
        return __instance;
    }

    public boolean isSafeMode() {
        return this._safeMode;
    }

    public Collection<PluginIssue> getErrors() {
        return this._errors;
    }

    public Set<String> getPluginNames() {
        return Collections.unmodifiableSet(this._plugins.keySet());
    }

    public Set<String> getBundledPluginsNames() {
        return Collections.unmodifiableSet(this._resourceURIs.keySet());
    }

    public Map<String, Plugin> getPlugins() {
        return Collections.unmodifiableMap(this._plugins);
    }

    public Map<String, Plugin> getAllPlugins() {
        return Collections.unmodifiableMap(this._allPlugins);
    }

    public Map<String, Feature> getFeatures() {
        return Collections.unmodifiableMap(this._features);
    }

    public Map<String, InactivityCause> getInactiveFeatures() {
        return Collections.unmodifiableMap(this._inactiveFeatures);
    }

    public Map<String, Collection<String>> getExtensionPoints() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String point : this._extensions.keySet()) {
            result.put(point, this._extensions.get(point).keySet());
        }
        return Collections.unmodifiableMap(result);
    }

    public Collection<String> getComponents() {
        return Collections.unmodifiableCollection(this._components.keySet());
    }

    public String getResourceURI(String pluginName) {
        String pluginUri = this._resourceURIs.get(pluginName);
        if (pluginUri == null || !this._plugins.containsKey(pluginName)) {
            return null;
        }
        return "resource:/" + pluginUri;
    }

    public File getPluginLocation(String pluginName) {
        return this._locations.get(pluginName);
    }

    public Status getStatus() {
        return this._status;
    }

    private void _setActivator(Context context) {
        Collection includedFeatures = null;
        try {
            includedFeatures = (Collection)context.get((Object)INCLUDED_FEATURES_CONTEXT_ATTRIBUTE);
        }
        catch (ContextException contextException) {
            // empty catch block
        }
        if (includedFeatures != null) {
            this._featureActivator = new IncludePolicyFeatureActivator(this._allPlugins, includedFeatures);
        } else {
            Collection<String> excludedPlugins = RuntimeConfig.getInstance().getExcludedPlugins();
            Collection<String> excludedFeatures = RuntimeConfig.getInstance().getExcludedFeatures();
            this._featureActivator = new ExcludePolicyFeatureActivator(this._allPlugins, excludedPlugins, excludedFeatures);
        }
        this._logger.debug("Using FeatureActivator '{}'", (Object)this._featureActivator.getClass().getSimpleName());
    }

    public PluginsComponentManager init(ComponentManager parentCM, Context context, String contextPath, boolean forceSafeMode) throws Exception {
        String shortDump;
        this._resourceURIs = new HashMap<String, String>();
        this._locations = new HashMap<String, File>();
        this._errors = new ArrayList<PluginIssue>();
        this._safeMode = false;
        this._initResourceURIs();
        Map<String, File> externalPlugins = RuntimeConfig.getInstance().getExternalPlugins();
        for (File plugin : externalPlugins.values()) {
            if (plugin.exists() && plugin.isDirectory()) continue;
            throw new RuntimeException("The configured external plugin is not an existing directory: " + plugin.getAbsolutePath());
        }
        Collection<String> locations = RuntimeConfig.getInstance().getPluginsLocations();
        Map<String, String> componentsConfig = RuntimeConfig.getInstance().getComponents();
        Collection<String> excludedPlugins = RuntimeConfig.getInstance().getExcludedPlugins();
        this._allPlugins = this._parsePlugins(contextPath, locations, externalPlugins, excludedPlugins);
        if (RuntimeConfig.getInstance().isSafeMode()) {
            this._status = Status.RUNTIME_NOT_LOADED;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        this._setActivator(context);
        FeatureActivator.PluginsInformation info = this._featureActivator.computeActiveFeatures(componentsConfig, this._safeMode);
        Map<String, Plugin> plugins = info.getPlugins();
        Map<String, Feature> features = info.getFeatures();
        this._errors.addAll(info.getErrors());
        if (this._logger.isInfoEnabled() && !(shortDump = this._featureActivator.shortDump(info)).isEmpty()) {
            this._logger.info("\n" + shortDump);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("All declared plugins : \n\n" + this._featureActivator.fullDump(info));
        }
        if (!this._errors.isEmpty()) {
            this._status = Status.WRONG_DEFINITIONS;
            PluginsComponentManager manager = this._enterSafeMode(parentCM, context, contextPath);
            return manager;
        }
        PluginsComponentManager configCM = new PluginsComponentManager(parentCM);
        configCM.setLogger(LoggerFactory.getLogger((String)"org.ametys.runtime.plugin.manager"));
        configCM.contextualize(context);
        PluginsComponentManager manager = new PluginsComponentManager(configCM);
        manager.setLogger(LoggerFactory.getLogger((String)"org.ametys.runtime.plugin.manager"));
        manager.contextualize(context);
        this._initializeConfigurationComponentManager(contextPath, info, configCM);
        ConfigManager configManager = ConfigManager.getInstance();
        configManager.contextualize(context);
        configManager.service((ServiceManager)new WrapperServiceManager((ComponentManager)configCM));
        configManager.initialize();
        this._parseConfiguration(configManager, plugins, features);
        if (forceSafeMode) {
            this._status = Status.SAFE_MODE_FORCED;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        if (configManager.isEmpty()) {
            this._status = Status.NO_CONFIG;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        if (!configManager.isComplete()) {
            this._status = Status.CONFIG_INCOMPLETE;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        ArrayList<PluginIssue> errors = new ArrayList<PluginIssue>();
        this._loadExtensionsPoints(manager, info.getExtensionPoints(), info.getExtensions(), contextPath, errors);
        this._loadComponents(manager, info.getComponents(), contextPath, errors);
        this._loadRuntimeInit(manager, errors);
        this._errors.addAll(errors);
        if (!errors.isEmpty()) {
            this._status = Status.NOT_INITIALIZED;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        this._plugins = plugins;
        this._features = features;
        this._inactiveFeatures = info.getInactiveFeatures();
        this._extensionPoints = info.getExtensionPoints();
        this._extensions = info.getExtensions();
        this._components = info.getComponents();
        try {
            manager.initialize();
        }
        catch (Exception e) {
            this._logger.error("Caught an exception loading components.", (Throwable)e);
            this._status = Status.NOT_INITIALIZED;
            this._errors.add(new PluginIssue(null, null, PluginIssue.PluginIssueCode.INITIALIZATION_EXCEPTION, null, e.getMessage(), e));
            manager.dispose();
            manager = null;
            PluginsComponentManager safeManager = this._enterSafeMode(parentCM, context, contextPath);
            return safeManager;
        }
        this._status = Status.OK;
        return manager;
    }

    private void _initializeConfigurationComponentManager(String contextPath, FeatureActivator.PluginsInformation pluginsInfo, PluginsComponentManager configCM) {
        ArrayList<PluginIssue> errorsOnConfigTypeEPLoading = new ArrayList<PluginIssue>();
        this._loadExtensionsPoint(configCM, ConfigParameterTypeExtensionPoint.ROLE, pluginsInfo.getExtensionPoints(), pluginsInfo.getExtensions(), contextPath, errorsOnConfigTypeEPLoading);
        this._errors.addAll(errorsOnConfigTypeEPLoading);
        if (!errorsOnConfigTypeEPLoading.isEmpty()) {
            throw new PluginException("Errors while loading extension points needed for configuration validation.", this._errors, null);
        }
        try {
            configCM.initialize();
        }
        catch (Exception e) {
            throw new PluginException("Caught exception while starting ComponentManager for configuration validation.", (Throwable)e, this._errors, null);
        }
    }

    private void _parseConfiguration(ConfigManager configManager, Map<String, Plugin> plugins, Map<String, Feature> features) {
        for (String pluginName : plugins.keySet()) {
            Plugin plugin = plugins.get(pluginName);
            configManager.addPluginConfig(pluginName, plugin.getConfigParameters(), plugin.getParameterCheckers());
        }
        for (String featureId : features.keySet()) {
            Feature feature = features.get(featureId);
            configManager.addFeatureConfig(feature.getFeatureId(), feature.getConfigParameters(), feature.getParameterCheckers(), feature.getConfigParametersReferences());
        }
        configManager.parseAndValidate();
    }

    private void _initResourceURIs() throws IOException {
        Enumeration<URL> pluginResources = this.getClass().getClassLoader().getResources("META-INF/ametys-plugins");
        while (pluginResources.hasMoreElements()) {
            URL pluginResource = pluginResources.nextElement();
            InputStream is = pluginResource.openStream();
            Throwable throwable = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                Throwable throwable2 = null;
                try {
                    String plugin;
                    while ((plugin = br.readLine()) != null) {
                        int i = plugin.indexOf(58);
                        if (i == -1) continue;
                        String pluginName = plugin.substring(0, i);
                        String pluginResourceURI = plugin.substring(i + 1);
                        this._resourceURIs.put(pluginName, pluginResourceURI);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (br == null) continue;
                    if (throwable2 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private Map<String, Plugin> _parsePlugins(String contextPath, Collection<String> locations, Map<String, File> externalPlugins, Collection<String> excludedPlugins) throws IOException {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        for (String pluginName : this._resourceURIs.keySet()) {
            String resourceURI = this._resourceURIs.get(pluginName) + FEATURE_ID_SEPARATOR + PLUGIN_FILENAME;
            if (this.getClass().getResource(resourceURI) == null) {
                this._pluginError(pluginName, "A plugin '" + pluginName + "' is declared in a jar, but no file '" + PLUGIN_FILENAME + "' can be found at '" + resourceURI + "'.", PluginIssue.PluginIssueCode.BUNDLED_PLUGIN_NOT_PRESENT, excludedPlugins, null);
            } else if (!pluginName.matches("^[a-zA-Z0-9](?:[a-zA-Z0-9-_\\.]*[a-zA-Z0-9])?$")) {
                this._pluginError(pluginName, pluginName + " is an incorrect plugin name.", PluginIssue.PluginIssueCode.PLUGIN_NAME_INVALID, excludedPlugins, null);
            } else if (plugins.containsKey(pluginName)) {
                this._pluginError(pluginName, "The plugin " + pluginName + " at " + resourceURI + " is already declared.", PluginIssue.PluginIssueCode.PLUGIN_NAME_EXIST, excludedPlugins, null);
            }
            this._logger.debug("Reading plugin configuration at {}", (Object)resourceURI);
            Configuration configuration = null;
            try (InputStream is = this.getClass().getResourceAsStream(resourceURI);){
                configuration = this._getConfigurationFromStream(pluginName, is, "resource:/" + resourceURI, excludedPlugins);
            }
            if (configuration == null) continue;
            Plugin plugin = new Plugin(pluginName);
            plugin.configure(configuration);
            plugins.put(pluginName, plugin);
            this._logger.info("Plugin '{}' found at path 'resource:/{}'", (Object)pluginName, (Object)resourceURI);
        }
        for (String location : locations) {
            File[] pluginDirs;
            File locationBase = new File(contextPath, location);
            if (!locationBase.exists() || !locationBase.isDirectory()) continue;
            for (File pluginDir : pluginDirs = locationBase.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                this._addPlugin(plugins, pluginDir.getName(), pluginDir, excludedPlugins);
            }
        }
        for (String externalPlugin : externalPlugins.keySet()) {
            File pluginDir = externalPlugins.get(externalPlugin);
            if (!pluginDir.exists() || !pluginDir.isDirectory()) continue;
            this._addPlugin(plugins, externalPlugin, pluginDir, excludedPlugins);
        }
        return plugins;
    }

    private void _addPlugin(Map<String, Plugin> plugins, String pluginName, File pluginDir, Collection<String> excludedPlugins) throws IOException {
        if (pluginName.matches(PLUGIN_NAMES_IGNORED)) {
            this._logger.debug("Skipping directory {} ...", (Object)pluginDir.getAbsolutePath());
            return;
        }
        if (!pluginName.matches("^[a-zA-Z0-9](?:[a-zA-Z0-9-_\\.]*[a-zA-Z0-9])?$")) {
            this._logger.warn("{} is an incorrect plugin directory name. It will be ignored.", (Object)pluginName);
            return;
        }
        File pluginFile = new File(pluginDir, PLUGIN_FILENAME);
        if (!pluginFile.exists()) {
            this._logger.warn("There is no file named {} in the directory {}. It will be ignored.", (Object)PLUGIN_FILENAME, (Object)pluginDir.getAbsolutePath());
            return;
        }
        if (plugins.containsKey(pluginName)) {
            this._pluginError(pluginName, "The plugin " + pluginName + " at " + pluginFile.getAbsolutePath() + " is already declared.", PluginIssue.PluginIssueCode.PLUGIN_NAME_EXIST, excludedPlugins, null);
            return;
        }
        this._logger.debug("Reading plugin configuration at {}", (Object)pluginFile.getAbsolutePath());
        Configuration configuration = null;
        try (FileInputStream is = new FileInputStream(pluginFile);){
            configuration = this._getConfigurationFromStream(pluginName, is, pluginFile.getAbsolutePath(), excludedPlugins);
        }
        if (configuration != null) {
            Plugin plugin = new Plugin(pluginName);
            plugin.configure(configuration);
            plugins.put(pluginName, plugin);
            this._locations.put(pluginName, pluginDir);
            this._logger.info("Plugin '{}' found at path '{}'", (Object)pluginName, (Object)pluginFile.getAbsolutePath());
        }
    }

    private Configuration _getConfigurationFromStream(String pluginName, InputStream is, String path, Collection<String> excludedPlugins) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = this.getClass().getResource("plugin-4.0.xsd");
            Schema schema = schemaFactory.newSchema(schemaURL);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            DefaultConfigurationBuilder confBuilder = new DefaultConfigurationBuilder(reader);
            return confBuilder.build(is, path);
        }
        catch (Exception e) {
            this._pluginError(pluginName, "Unable to access to plugin '" + pluginName + "' at " + path, PluginIssue.PluginIssueCode.CONFIGURATION_UNREADABLE, excludedPlugins, e);
            return null;
        }
    }

    private void _pluginError(String pluginName, String message, PluginIssue.PluginIssueCode code, Collection<String> excludedPlugins, Exception e) {
        if (!excludedPlugins.contains(pluginName)) {
            PluginIssue issue = new PluginIssue(null, null, code, null, message, e);
            this._errors.add(issue);
            this._logger.error(message, (Throwable)e);
        }
    }

    private void _loadExtensionsPoint(PluginsComponentManager manager, String point, Map<String, ExtensionPointDefinition> extensionPoints, Map<String, Map<String, ExtensionDefinition>> extensionsDefinitions, String contextPath, Collection<PluginIssue> errors) {
        ExtensionPointDefinition definition = extensionPoints.get(point);
        Configuration conf = definition._configuration;
        String clazz = conf.getAttribute("class", null);
        String pluginName = definition._pluginName;
        try {
            Class<?> c = Class.forName(clazz);
            if (ExtensionPoint.class.isAssignableFrom(c)) {
                Class<ExtensionPoint> extensionClass = c.asSubclass(ExtensionPoint.class);
                ArrayList<ExtensionDefinition> extensionDefinitions = new ArrayList<ExtensionDefinition>();
                Map<String, ExtensionDefinition> initialDefinitions = extensionsDefinitions.get(point);
                if (initialDefinitions != null) {
                    for (String id : initialDefinitions.keySet()) {
                        ExtensionDefinition extensionDefinition = initialDefinitions.get(id);
                        Configuration initialConf = extensionDefinition.getConfiguration();
                        Configuration realExtensionConf = this._getComponentConfiguration(initialConf, contextPath, extensionDefinition.getPluginName(), errors);
                        extensionDefinitions.add(new ExtensionDefinition(id, point, extensionDefinition.getPluginName(), extensionDefinition.getFeatureName(), realExtensionConf));
                    }
                }
                Configuration realComponentConf = this._getComponentConfiguration(conf, contextPath, pluginName, errors);
                manager.addExtensionPoint(pluginName, point, extensionClass, realComponentConf, extensionDefinitions);
            } else {
                String message = "In plugin '" + pluginName + "', the extension point '" + point + "' references class '" + clazz + "' which don't implement " + ExtensionPoint.class.getName();
                this._logger.error(message);
                PluginIssue issue = new PluginIssue(pluginName, null, PluginIssue.PluginIssueCode.EXTENSIONPOINT_CLASS_INVALID, conf.getLocation(), message);
                errors.add(issue);
            }
        }
        catch (ClassNotFoundException e) {
            String message = "In plugin '" + pluginName + "', the extension point '" + point + "' references the unexisting class '" + clazz + "'.";
            this._logger.error(message, (Throwable)e);
            PluginIssue issue = new PluginIssue(pluginName, null, PluginIssue.PluginIssueCode.CLASSNOTFOUND, conf.getLocation(), message);
            errors.add(issue);
        }
    }

    private void _loadExtensionsPoints(PluginsComponentManager manager, Map<String, ExtensionPointDefinition> extensionPoints, Map<String, Map<String, ExtensionDefinition>> extensionsDefinitions, String contextPath, Collection<PluginIssue> errors) {
        for (String point : extensionPoints.keySet()) {
            if (ConfigParameterTypeExtensionPoint.ROLE.equals(point)) continue;
            this._loadExtensionsPoint(manager, point, extensionPoints, extensionsDefinitions, contextPath, errors);
        }
    }

    private void _loadComponents(PluginsComponentManager manager, Map<String, ComponentDefinition> components, String contextPath, Collection<PluginIssue> errors) {
        for (String role : components.keySet()) {
            ComponentDefinition componentDefinition = components.get(role);
            Configuration componentConf = componentDefinition.getConfiguration();
            Configuration realComponentConf = this._getComponentConfiguration(componentConf, contextPath, componentDefinition.getPluginName(), errors);
            String clazz = componentConf.getAttribute("class", null);
            assert (clazz != null);
            try {
                Class<?> c = Class.forName(clazz);
                manager.addComponent(componentDefinition.getPluginName(), componentDefinition.getFeatureName(), role, c, realComponentConf);
            }
            catch (ClassNotFoundException ex) {
                String message = "In feature '" + componentDefinition.getPluginName() + FEATURE_ID_SEPARATOR + componentDefinition.getFeatureName() + "', the component '" + role + "' references the unexisting class '" + clazz + "'.";
                this._logger.error(message, (Throwable)ex);
                PluginIssue issue = new PluginIssue(componentDefinition.getPluginName(), componentDefinition.getFeatureName(), PluginIssue.PluginIssueCode.CLASSNOTFOUND, componentConf.getLocation(), message);
                errors.add(issue);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configuration _getComponentConfiguration(Configuration initialConfiguration, String contextPath, String pluginName, Collection<PluginIssue> errors) {
        String config = initialConfiguration.getAttribute("config", null);
        if (config == null) return initialConfiguration;
        String configPath = null;
        try {
            if (config.startsWith(FEATURE_ID_SEPARATOR)) {
                File configFile = new File(contextPath, config);
                configPath = configFile.getAbsolutePath();
                if (!configFile.exists() || configFile.isDirectory()) {
                    if (!this._logger.isInfoEnabled()) return initialConfiguration;
                    this._logger.info("No config file was found at " + configPath + ". Using internally declared config.");
                    return initialConfiguration;
                }
                try (FileInputStream is = new FileInputStream(configFile);){
                    Configuration configuration = new DefaultConfigurationBuilder(true).build((InputStream)is, configPath);
                    return configuration;
                }
            }
            String baseUri = this._resourceURIs.get(pluginName);
            if (baseUri == null) {
                File pluginLocation = this.getPluginLocation(pluginName);
                File configFile = new File(pluginLocation, config);
                configPath = configFile.getAbsolutePath();
                if (!configFile.exists() || configFile.isDirectory()) {
                    if (!this._logger.isInfoEnabled()) return initialConfiguration;
                    this._logger.info("No config file was found at " + configPath + ". Using internally declared config.");
                    return initialConfiguration;
                }
                try (FileInputStream is = new FileInputStream(configFile);){
                    Configuration configuration = new DefaultConfigurationBuilder(true).build((InputStream)is, configPath);
                    return configuration;
                }
            }
            String path = baseUri + FEATURE_ID_SEPARATOR + config;
            configPath = "resource:/" + path;
            try (InputStream is = this.getClass().getResourceAsStream(path);){
                if (is == null) {
                    if (this._logger.isInfoEnabled()) {
                        this._logger.info("No config file was found at " + configPath + ". Using internally declared config.");
                    }
                    Configuration configuration = initialConfiguration;
                    return configuration;
                }
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is, configPath);
                return configuration;
            }
        }
        catch (Exception ex) {
            String message = "Unable to load external configuration defined in the plugin " + pluginName;
            this._logger.error(message, (Throwable)ex);
            PluginIssue issue = new PluginIssue(pluginName, null, PluginIssue.PluginIssueCode.EXTERNAL_CONFIGURATION, initialConfiguration.getLocation(), message);
            errors.add(issue);
        }
        return initialConfiguration;
    }

    private void _loadRuntimeInit(PluginsComponentManager manager, Collection<PluginIssue> errors) {
        String className = RuntimeConfig.getInstance().getInitClassName();
        if (className != null) {
            this._logger.info("Loading init class '{}' for application", (Object)className);
            try {
                Class<?> initClass = Class.forName(className);
                if (!Init.class.isAssignableFrom(initClass)) {
                    String message = "Provided init class " + initClass + " does not implement " + Init.class.getName();
                    this._logger.error(message);
                    PluginIssue issue = new PluginIssue(null, null, PluginIssue.PluginIssueCode.INIT_CLASS_INVALID, null, message);
                    errors.add(issue);
                    return;
                }
                manager.addComponent(null, null, Init.ROLE, initClass, (Configuration)new DefaultConfiguration("component"));
                this._logger.info("Init class {} loaded", (Object)className);
            }
            catch (ClassNotFoundException e) {
                String message = "The application init class '" + className + "' does not exist.";
                this._logger.error(message, (Throwable)e);
                PluginIssue issue = new PluginIssue(null, null, PluginIssue.PluginIssueCode.CLASSNOTFOUND, null, message);
                errors.add(issue);
            }
        } else if (this._logger.isInfoEnabled()) {
            this._logger.info("No init class configured");
        }
    }

    private PluginsComponentManager _enterSafeMode(ComponentManager parentCM, Context context, String contextPath) throws Exception {
        Collection<PluginIssue> errors;
        this._logger.info("Entering safe mode due to previous errors ...");
        this._safeMode = true;
        ExcludePolicyFeatureActivator safeModeFeatureActivator = new ExcludePolicyFeatureActivator(this._allPlugins, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        FeatureActivator.PluginsInformation info = safeModeFeatureActivator.computeActiveFeatures(Collections.EMPTY_MAP, this._safeMode);
        this._plugins = info.getPlugins();
        this._extensionPoints = info.getExtensionPoints();
        this._components = info.getComponents();
        this._extensions = info.getExtensions();
        this._features = info.getFeatures();
        this._inactiveFeatures = info.getInactiveFeatures();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Safe mode : \n\n" + safeModeFeatureActivator.fullDump(info));
        }
        if (!(errors = info.getErrors()).isEmpty()) {
            throw new PluginException("Errors while loading components in safe mode.", this._errors, errors);
        }
        PluginsComponentManager configCM = new PluginsComponentManager(parentCM);
        configCM.setLogger(LoggerFactory.getLogger((String)"org.ametys.runtime.plugin.manager"));
        configCM.contextualize(context);
        PluginsComponentManager manager = new PluginsComponentManager(configCM);
        manager.setLogger(LoggerFactory.getLogger((String)"org.ametys.runtime.plugin.manager"));
        manager.contextualize(context);
        this._loadExtensionsPoint(configCM, ConfigParameterTypeExtensionPoint.ROLE, info.getExtensionPoints(), info.getExtensions(), contextPath, errors);
        configCM.initialize();
        ConfigManager.getInstance().service((ServiceManager)new WrapperServiceManager((ComponentManager)configCM));
        errors = new ArrayList<PluginIssue>();
        this._loadExtensionsPoints(manager, this._extensionPoints, this._extensions, contextPath, errors);
        this._loadComponents(manager, this._components, contextPath, errors);
        if (!errors.isEmpty()) {
            throw new PluginException("Errors while loading components in safe mode.", this._errors, errors);
        }
        try {
            manager.initialize();
        }
        catch (Exception e) {
            throw new PluginException("Caught exception while starting ComponentManager in safe mode.", (Throwable)e, this._errors, null);
        }
        return manager;
    }

    public static enum Status {
        OK,
        NO_CONFIG,
        CONFIG_INCOMPLETE,
        WRONG_DEFINITIONS,
        NOT_INITIALIZED,
        RUNTIME_NOT_LOADED,
        SAFE_MODE_FORCED;

    }

    public static enum InactivityCause {
        EXCLUDED,
        DEACTIVATED,
        COMPONENT,
        DEPENDENCY,
        PASSIVE,
        INVALID_POINT,
        NOT_SAFE,
        UNUSED;

    }
}

