/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin.component;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentExtensionPoint<T>
extends AbstractLogEnabled
implements ExtensionPoint<T>,
Component,
ThreadSafe,
Serviceable,
Contextualizable,
Initializable,
Disposable {
    protected ServiceManager _manager;
    protected Context _context;
    protected Map<String, ExtensionConfiguration> _extensions;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    public void initialize() throws Exception {
        this._extensions = new HashMap<String, ExtensionConfiguration>();
    }

    public void dispose() {
        this._extensions = null;
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        Class<?> extensionClass;
        String className;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuring extension '" + id + "' in plugin '" + pluginName + "' id '" + featureName + "'.");
        }
        if ((className = configuration.getAttribute("class", null)) == null) {
            throw new ConfigurationException("In plugin '" + pluginName + "' id '" + featureName + "', extension '" + id + "' does not defines any class", configuration);
        }
        try {
            extensionClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("Unable to instanciate class '" + className + "' for plugin '" + pluginName + "' / '" + featureName + "'", configuration, (Throwable)ex);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Extension configured");
        }
        ExtensionConfiguration ec = new ExtensionConfiguration(pluginName, featureName, configuration, extensionClass);
        this._extensions.put(id, ec);
    }

    @Override
    public T getExtension(String id) {
        Object t;
        ExtensionConfiguration ec = this._extensions.get(id);
        if (ec == null) {
            throw new IllegalArgumentException("Id " + id + " is not a correct component identifier.");
        }
        Class extensionClass = ec.getExtensionClass();
        try {
            t = extensionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instanciate the class " + extensionClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
        }
        try {
            if (t instanceof PluginAware) {
                ((PluginAware)t).setPluginInfo(ec.getPluginName(), ec.getFeatureName(), id);
            }
            if (t instanceof LogEnabled) {
                Configuration config = ec.getConfiguration();
                String logger = config == null ? null : config.getAttribute("logger", null);
                logger = logger != null ? logger : extensionClass.getName();
                ((LogEnabled)t).setLogger(LoggerFactory.getLogger((String)logger));
            }
            LifecycleHelper.setupComponent(t, (Logger)this.getLogger(), (Context)this._context, (ServiceManager)this._manager, (Configuration)ec.getConfiguration(), (boolean)true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot initiate the class " + extensionClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
        }
        return t;
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._extensions.keySet();
    }

    @Override
    public boolean hasExtension(String id) {
        return this._extensions.containsKey(id);
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    protected class ExtensionConfiguration {
        private String _pluginName;
        private String _featureName;
        private Configuration _configuration;
        private Class<T> _extensionClass;

        protected ExtensionConfiguration(String pluginName, String featureName, Configuration configuration, Class<T> extensionClass) {
            this._pluginName = pluginName;
            this._featureName = featureName;
            this._configuration = configuration;
            this._extensionClass = extensionClass;
        }

        public Class<T> getExtensionClass() {
            return this._extensionClass;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public String getFeatureName() {
            return this._featureName;
        }

        public String getPluginName() {
            return this._pluginName;
        }
    }
}

