/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin.component;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadSafeComponentExtensionPoint<T>
extends AbstractLogEnabled
implements ExtensionPoint<T>,
Component,
ThreadSafe,
Serviceable,
Initializable,
Disposable,
Contextualizable {
    protected ThreadSafeComponentManager<T> _manager;
    protected ServiceManager _cocoonManager;
    protected Context _context;
    private Set<String> _ids = new LinkedHashSet<String>();

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._cocoonManager = manager;
    }

    public void initialize() throws Exception {
        this._manager = new ThreadSafeComponentManager();
        this._manager.setLogger(LoggerFactory.getLogger((String)"runtime.plugin.threadsafecomponent"));
        this._manager.contextualize(this._context);
        this._manager.service(this._cocoonManager);
    }

    public void dispose() {
        this._manager.dispose();
    }

    protected void addComponent(String pluginName, String featureName, String role, Class<? extends T> clazz, Configuration configuration) throws ComponentException {
        this._ids.add(role);
        this._manager.addComponent(pluginName, featureName, role, clazz, configuration);
    }

    @Override
    public void initializeExtensions() throws Exception {
        this._manager.initialize();
    }

    @Override
    public T getExtension(String id) {
        try {
            return this._manager.lookup(id);
        }
        catch (ComponentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean hasExtension(String id) {
        return this._ids.contains(id);
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        Class<?> extensionClass;
        String className;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuring extension '" + id + "' in plugin '" + pluginName + "' id '" + featureName + "'.");
        }
        if ((className = configuration.getAttribute("class", null)) == null) {
            throw new ConfigurationException("In plugin '" + pluginName + "' id '" + featureName + "', extension '" + id + "' does not defines any class", configuration);
        }
        try {
            extensionClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("Unable to instanciate class '" + className + "' for plugin '" + pluginName + "' / '" + featureName + "'", configuration, (Throwable)ex);
        }
        try {
            this.addComponent(pluginName, featureName, id, extensionClass, configuration);
        }
        catch (ComponentException e) {
            throw new ConfigurationException("Exception loading extension " + id, (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Extension configured");
        }
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._ids;
    }
}

