/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.ParentAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;

public class PluginsComponentManager
extends ThreadSafeComponentManager<Object>
implements ComponentManager {
    ComponentManager _parentManager;
    private Map<String, Collection<ExtensionDefinition>> _extensionPoints = new HashMap<String, Collection<ExtensionDefinition>>();

    public PluginsComponentManager(ComponentManager parentManager) {
        this._parentManager = parentManager;
    }

    @Override
    public boolean hasComponent(String role) {
        if (super.hasRole(role)) {
            return true;
        }
        if (this._parentManager != null) {
            return this._parentManager.hasComponent(role);
        }
        return false;
    }

    @Override
    public Component lookup(String role) throws ComponentException {
        Component component = (Component)super.lookup(role);
        if (component != null) {
            return component;
        }
        if (this._parentManager != null) {
            return this._parentManager.lookup(role);
        }
        return null;
    }

    public void release(Component object) {
        if (!super.hasComponent(object) && this._parentManager != null) {
            this._parentManager.release(object);
        }
    }

    public void addExtensionPoint(String pluginName, String point, Class<? extends ExtensionPoint> extensionPoint, Configuration configuration, Collection<ExtensionDefinition> extensions) {
        ExtensionPointFactory factory = new ExtensionPointFactory(pluginName, null, point, extensionPoint, configuration, (ServiceManager)new WrapperServiceManager((ComponentManager)this), this.getLogger(), extensions);
        this._addComponent(point, factory);
        this._extensionPoints.put(point, extensions);
    }

    @Override
    ThreadSafeComponentManager.ComponentFactory getComponentFactory(String pluginName, String featureName, String role, Class<? extends Object> componentClass, Configuration configuration) {
        return new ProxyComponentFactory(pluginName, featureName, role, componentClass, configuration, (ServiceManager)new WrapperServiceManager((ComponentManager)this), this.getLogger());
    }

    private class ExtensionPointFactory
    extends ProxyComponentFactory {
        private Collection<ExtensionDefinition> _extensions;

        public ExtensionPointFactory(String pluginName, String featureName, String role, Class<? extends ExtensionPoint> extensionPointClass, Configuration configuration, ServiceManager serviceManager, Logger logger, Collection<ExtensionDefinition> extensions) {
            super(pluginName, featureName, role, extensionPointClass, configuration, serviceManager, logger);
            this._extensions = extensions;
        }

        @Override
        Component newInstance() throws Exception {
            Object component = this.instanciate();
            PluginsComponentManager.this._componentsInitializing.put(this._role, component);
            if (component instanceof ParentAware && PluginsComponentManager.this._parentManager != null) {
                Component parent = PluginsComponentManager.this._parentManager.lookup(this._role);
                ((ParentAware)component).setParent(parent);
            }
            this.configureAndStart(component);
            ExtensionPoint extPoint = (ExtensionPoint)component;
            for (ExtensionDefinition extension : this._extensions) {
                extPoint.addExtension(extension.getId(), extension.getPluginName(), extension.getFeatureName(), extension.getConfiguration());
            }
            PluginsComponentManager.this.getLogger().debug("Initializing extensions for point {}", (Object)this._role);
            extPoint.initializeExtensions();
            PluginsComponentManager.this._componentsInitializing.remove(this._role);
            return this.proxify(component);
        }
    }

    private class ComponentInvocationHandler
    implements InvocationHandler {
        private final Object _delegate;

        ComponentInvocationHandler(Object delegate) {
            this._delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method meth, Object[] args) throws Throwable {
            try {
                return meth.invoke(this._delegate, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }

    private class ProxyComponentFactory
    extends ThreadSafeComponentManager.ComponentFactory {
        ProxyComponentFactory(String pluginName, String featureName, String role, Class<? extends Object> componentClass, Configuration configuration, ServiceManager serviceManager, Logger logger) {
            super(PluginsComponentManager.this, pluginName, featureName, role, componentClass, configuration, serviceManager, logger);
        }

        Component proxify(Object component) {
            if (component instanceof Component) {
                return (Component)component;
            }
            List interfaces = ClassUtils.getAllInterfaces(component.getClass());
            interfaces.add(Component.class);
            Class[] proxyInterfaces = interfaces.toArray(new Class[0]);
            return (Component)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), proxyInterfaces, (InvocationHandler)new ComponentInvocationHandler(component));
        }

        Component newInstance() throws Exception {
            Object component = this.instanciate();
            PluginsComponentManager.this._componentsInitializing.put(this._role, component);
            if (component instanceof ParentAware && PluginsComponentManager.this._parentManager != null) {
                Component parent = PluginsComponentManager.this._parentManager.lookup(this._role);
                ((ParentAware)component).setParent(parent);
            }
            this.configureAndStart(component);
            PluginsComponentManager.this._componentsInitializing.remove(this._role);
            return this.proxify(component);
        }
    }
}

