/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeComponentManager<T>
extends AbstractLogEnabled
implements Contextualizable,
Initializable,
Disposable,
Serviceable {
    protected ServiceManager _manager;
    Context _context;
    Map<String, T> _componentsInitializing = new HashMap<String, T>();
    private Map<String, T> _components = new LinkedHashMap<String, T>();
    private Map<String, ComponentFactory> _componentFactories = Collections.synchronizedMap(new LinkedHashMap());
    private boolean _disposed;
    private boolean _initialized;

    public void service(ServiceManager manager) {
        this._manager = manager;
    }

    public void contextualize(Context context) {
        this._context = context;
    }

    public T lookup(String role) throws ComponentException {
        if (!this._initialized) {
            String message = "Looking up component on an uninitialized ThreadSafeComponentManager [" + role + "]";
            this.getLogger().debug(message);
            return null;
        }
        if (this._disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ThreadSafeComponentManager");
        }
        if (role == null) {
            throw new ComponentException(role, "ThreadSafeComponentManager attempted to retrieve component with null role.");
        }
        T component = this._components.get(role);
        if (component == null) {
            if (this._componentsInitializing.containsKey(role)) {
                this.getLogger().debug("Trying to lookup the component '{}' during its own initialization", (Object)role);
                return this._componentsInitializing.get(role);
            }
            if (this._componentFactories.containsKey(role)) {
                try {
                    this.getLogger().debug("Trying to lookup an uninitializing component '{}'. It will be initialized right now.", (Object)role);
                    component = this._componentFactories.get(role).newInstance();
                }
                catch (Exception e) {
                    throw new ComponentException(role, "Unable to initialize component " + role, (Throwable)e);
                }
            }
            this._components.put(role, component);
        }
        return component;
    }

    public boolean hasRole(String role) {
        if (!this._initialized || this._disposed) {
            return false;
        }
        return this._components.containsKey(role) || this._componentsInitializing.containsKey(role) || this._componentFactories.containsKey(role);
    }

    public boolean hasComponent(T component) {
        if (!this._initialized || this._disposed) {
            return false;
        }
        return this._components.containsValue(component) || this._componentsInitializing.containsValue(component) || this._componentFactories.containsValue(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        if (this._initialized) {
            throw new IllegalStateException("ComponentManager has already been initialized");
        }
        ThreadSafeComponentManager threadSafeComponentManager = this;
        synchronized (threadSafeComponentManager) {
            this._initialized = true;
            for (String role : this._componentFactories.keySet()) {
                if (this._components.containsKey(role)) continue;
                ComponentFactory factory = this._componentFactories.get(role);
                try {
                    this.getLogger().debug("Initializing component for role {}", (Object)role);
                    Object component = factory.newInstance();
                    this._components.put(role, component);
                }
                catch (Exception e) {
                    throw new Exception("Caught an exception trying to initialize the component " + role, e);
                }
            }
            this._componentFactories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ThreadSafeComponentManager threadSafeComponentManager = this;
        synchronized (threadSafeComponentManager) {
            for (String role : this._components.keySet()) {
                T component = this._components.get(role);
                try {
                    if (component instanceof Startable) {
                        ((Startable)component).stop();
                    }
                    if (!(component instanceof Disposable)) continue;
                    ((Disposable)component).dispose();
                }
                catch (Exception e) {
                    this.getLogger().error("Caught an exception trying to dispose the component " + role, (Throwable)e);
                }
            }
            this._components.clear();
            this._disposed = true;
        }
    }

    public void addComponent(String pluginName, String featureName, String role, Class<? extends T> component, Configuration configuration) {
        if (Poolable.class.isAssignableFrom(component) || SingleThreaded.class.isAssignableFrom(component)) {
            throw new IllegalArgumentException("The class " + component.getName() + " implements SingleThreaded, or Poolable, which is not allowed by this ComponentManager");
        }
        ComponentFactory factory = this.getComponentFactory(pluginName, featureName, role, component, configuration);
        this._addComponent(role, factory);
    }

    void _addComponent(String role, ComponentFactory factory) {
        if (this._initialized) {
            throw new IllegalStateException("Cannot add components to an initialized ComponentManager");
        }
        if (this._componentFactories.containsKey(role)) {
            throw new IllegalArgumentException("A component for the role '" + role + "' is already registered on this ComponentManager.");
        }
        this.getLogger().debug("Registering factory for role [{}]", (Object)role);
        this._componentFactories.put(role, factory);
    }

    ComponentFactory getComponentFactory(String pluginName, String featureName, String role, Class<? extends T> componentClass, Configuration configuration) {
        return new ComponentFactory(pluginName, featureName, role, componentClass, configuration, this._manager, this.getLogger());
    }

    class ComponentFactory {
        String _pluginName;
        String _featureName;
        String _role;
        Class<? extends T> _componentClass;
        Configuration _configuration;
        ServiceManager _serviceManager;
        Logger _logger;

        ComponentFactory(String pluginName, String featureName, String role, Class<? extends T> componentClass, Configuration configuration, ServiceManager serviceManager, Logger logger) {
            this._pluginName = pluginName;
            this._featureName = featureName;
            this._componentClass = componentClass;
            this._configuration = configuration;
            this._role = role;
            this._serviceManager = serviceManager;
            this._logger = logger;
        }

        T instanciate() throws Exception {
            Object component = this._componentClass.newInstance();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("ComponentFactory creating new instance of " + this._componentClass.getName() + ".");
            }
            String logger = this._configuration == null ? null : this._configuration.getAttribute("logger", null);
            String string = logger = logger != null ? logger : this._componentClass.getName();
            if (component instanceof LogEnabled) {
                ((LogEnabled)component).setLogger(LoggerFactory.getLogger((String)logger));
            }
            if (component instanceof org.apache.avalon.framework.logger.LogEnabled) {
                ContainerUtil.enableLogging(component, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(LoggerFactory.getLogger((String)logger)));
            }
            if (component instanceof Contextualizable) {
                ContainerUtil.contextualize(component, (Context)ThreadSafeComponentManager.this._context);
            }
            if (component instanceof PluginAware) {
                ((PluginAware)component).setPluginInfo(this._pluginName, this._featureName, this._role);
            }
            return component;
        }

        void configureAndStart(T component) throws Exception {
            ContainerUtil.service(component, (ServiceManager)this._serviceManager);
            ContainerUtil.configure(component, (Configuration)this._configuration);
            if (component instanceof Parameterizable) {
                Parameters parameters = Parameters.fromConfiguration((Configuration)this._configuration);
                ContainerUtil.parameterize(component, (Parameters)parameters);
            }
            ContainerUtil.initialize(component);
            ContainerUtil.start(component);
        }

        T newInstance() throws Exception {
            Object component = this.instanciate();
            ThreadSafeComponentManager.this._componentsInitializing.put(this._role, component);
            this.configureAndStart(component);
            ThreadSafeComponentManager.this._componentsInitializing.remove(this._role);
            return component;
        }
    }
}

