/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class SaveConfigAction
extends AbstractAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting SaveConfigAction");
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            ConfigManager configManager = ConfigManager.getInstance();
            Collection<ElementDefinition> definitions = configManager.getConfigurationParameters();
            HashMap<String, List<I18nizableText>> errorFields = new HashMap<String, List<I18nizableText>>();
            for (ElementDefinition definition : definitions) {
                String parameterId = definition.getName();
                try {
                    Object value = this._getTypedValueFromRequest(request, definition);
                    values.put(parameterId, value);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("The configuration parameter '" + parameterId + "' is not valid.", (Throwable)e);
                    }
                    I18nizableText errorLabel = new I18nizableText("plugin.core", "PLUGINS_CORE_SAVE_PARAMETER_VALUE_INVALID", Collections.singletonList(e.getMessage()));
                    errorFields.put(parameterId, Collections.singletonList(errorLabel));
                }
            }
            if (errorFields.isEmpty()) {
                String configFileName = new File(AmetysHomeHelper.getAmetysHomeConfig(), "config.xml").getCanonicalPath();
                errorFields.putAll(configManager.save(values, configFileName));
            }
            if (!errorFields.isEmpty()) {
                for (String paramId : errorFields.keySet()) {
                    List errors = (List)errorFields.get(paramId);
                    result.put(paramId, errors);
                }
                request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
                return EMPTY_MAP;
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while saving config modifications", (Throwable)e);
            result.put("error", e.getMessage());
            request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
            return EMPTY_MAP;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Positionning org.ametys.runtime.reload=true for Cocoon reloading");
        }
        request.setAttribute("org.ametys.runtime.reload", (Object)true);
        return EMPTY_MAP;
    }

    private Object _getTypedValueFromRequest(Request request, ElementDefinition definition) {
        String parameterId = definition.getName();
        ElementType type = definition.getType();
        Object[] value = null;
        if (definition.isMultiple()) {
            String[] valuesAsString = request.getParameterValues(parameterId);
            if (valuesAsString != null) {
                ArrayList valuesAsList = new ArrayList();
                for (String valueAsString : valuesAsString) {
                    valuesAsList.add(type.castValue(valueAsString));
                }
                value = valuesAsList.toArray(new Object[valuesAsList.size()]);
            }
        } else {
            String valueAsString = request.getParameter(parameterId);
            value = (Object[])definition.getType().castValue(valueAsString);
        }
        return value;
    }
}

