/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraphDef;

public abstract class AbstractSampleManager
implements SampleManager,
MonitoringConstants,
ThreadSafe,
LogEnabled,
Configurable,
PluginAware {
    protected Logger _logger;
    protected String _pluginName;
    protected String _featureName;
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        boolean isLabelI18n = configuration.getChild("label").getAttributeAsBoolean("i18n", false);
        String label = configuration.getChild("label").getValue(null);
        boolean isDescriptionI18n = configuration.getChild("description").getAttributeAsBoolean("i18n", false);
        String description = configuration.getChild("description").getValue(null);
        if (StringUtils.isEmpty((String)label) || StringUtils.isEmpty((String)description)) {
            throw new ConfigurationException("Missing <label> or <description>", configuration);
        }
        this._label = isLabelI18n ? new I18nizableText("plugin." + this._pluginName, label) : new I18nizableText(label);
        this._description = isDescriptionI18n ? new I18nizableText("plugin." + this._pluginName, description) : new I18nizableText(description);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void configureRRDDef(RrdDef rrdDef) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Configuring RRD definition for sample manager: " + this.getId());
        }
        rrdDef.setStartTime(new Date());
        this._configureDatasources(rrdDef);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 1440);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, 1440);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 10, 1008);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 10, 1008);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 120, 360);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 120, 360);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 360, 360);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 360, 360);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1440, 365);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 1440, 365);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 10080, 260);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 10080, 260);
    }

    protected abstract void _configureDatasources(RrdDef var1);

    protected void _registerDatasources(RrdDef rrdDef, String dsName, DsType dsType, double minValue, double maxValue) {
        rrdDef.addDatasource(dsName, dsType, 120L, minValue, maxValue);
    }

    @Override
    public Map<String, Object> collect(Sample sample) throws IOException {
        sample.setTime(Util.getTime());
        Map<String, Object> collectedValues = this._internalCollect(sample);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Data collected: " + sample.dump());
        }
        sample.update();
        return collectedValues;
    }

    protected abstract Map<String, Object> _internalCollect(Sample var1) throws IOException;

    protected void _setCommonParameters(RrdGraphDef graphDef) {
        graphDef.setColor(1, (Paint)new Color(255, 255, 255));
        graphDef.setColor(0, (Paint)new Color(255, 255, 255));
        graphDef.setColor(7, (Paint)new Color(255, 255, 255));
        graphDef.setColor(5, (Paint)new Color(128, 128, 128));
        graphDef.setColor(4, (Paint)new Color(220, 220, 220));
        graphDef.setColor(2, (Paint)new Color(220, 220, 220));
        graphDef.setColor(3, (Paint)new Color(220, 220, 220));
    }

    protected void _configureValueRange(RrdGraphDef graphDef) {
        graphDef.setMinValue(0.0);
    }

    protected abstract String _getGraphTitle();
}

