/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.logs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.runtime.plugins.admin.logs.LoggerComparator;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;

public class GetLogsLevel
extends ServiceableAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        try {
            LoggerRepository loggerRepository = LogManager.getLoggerRepository();
            ArrayList loggers = new ArrayList();
            Enumeration enumLogger = loggerRepository.getCurrentLoggers();
            while (enumLogger.hasMoreElements()) {
                loggers.add(enumLogger.nextElement());
            }
            loggers.add(loggerRepository.getRootLogger());
            Collections.sort(loggers, new LoggerComparator());
            HashMap<String, Object> logCategories = new HashMap<String, Object>();
            HashSet categoryLevels = new HashSet();
            for (Logger logger : loggers) {
                Level level = logger.getLevel();
                String category = logger.getName();
                if (category.equals("root")) {
                    logCategories.put("children", new ArrayList());
                    logCategories.put("name", "root");
                    logCategories.put("fullname", "root");
                    logCategories.put("level", level.toString());
                    continue;
                }
                HashMap<String, String> categoryLevel = new HashMap<String, String>();
                categoryLevel.put("category", category);
                categoryLevel.put("level", level == null ? "inherit" : level.toString());
                categoryLevels.add(categoryLevel);
            }
            String fullName = null;
            for (Map map : categoryLevels) {
                fullName = (String)map.get("category");
                this.createCategory((List)logCategories.get("children"), fullName, (String)map.get("level"), fullName);
            }
            result.put("children", logCategories);
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to access internal logger properties", (Throwable)e);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    public void createCategory(List<Map<String, Object>> children, String categoryName, String level, String fullName) {
        int i = categoryName.indexOf(".");
        if (i != -1) {
            String parentCategoryName = categoryName.substring(0, i);
            String childCategoryName = categoryName.substring(i + 1);
            Map<String, Object> parentCategoryNode = this._getNode(children, parentCategoryName);
            if (parentCategoryNode == null) {
                parentCategoryNode = new HashMap<String, Object>();
                parentCategoryNode.put("children", new ArrayList());
                parentCategoryNode.put("leaf", false);
                parentCategoryNode.put("level", "inherit");
                parentCategoryNode.put("name", parentCategoryName);
                parentCategoryNode.put("fullname", fullName.substring(0, fullName.indexOf(parentCategoryName)) + parentCategoryName);
                children.add(parentCategoryNode);
            }
            parentCategoryNode.put("leaf", false);
            this.createCategory((List)parentCategoryNode.get("children"), childCategoryName, level, fullName);
        } else {
            Map<String, Object> categoryNode = this._getNode(children, categoryName);
            if (categoryNode == null) {
                categoryNode = new HashMap<String, Object>();
                categoryNode.put("children", new ArrayList());
                categoryNode.put("leaf", true);
                categoryNode.put("level", level);
                categoryNode.put("name", categoryName);
                categoryNode.put("fullname", fullName);
                children.add(categoryNode);
            } else {
                categoryNode.put("level", level);
            }
        }
    }

    private Map<String, Object> _getNode(List<Map<String, Object>> children, String categoryName) {
        for (Map<String, Object> child : children) {
            if (!StringUtils.equals((CharSequence)((String)child.get("name")), (CharSequence)categoryName)) continue;
            return child;
        }
        return null;
    }
}

