/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.superuser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.right.Profile;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SuperUserClientSideElement
extends StaticClientSideElement {
    protected ServiceManager _sManager;
    protected RightsExtensionPoint _rightsEP;
    protected RightProfilesDAO _profilesDAO;
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightAssignmentContextExtensionPoint _rightCtxEP;
    protected UserHelper _userHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sManager = smanager;
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
    }

    @Callable
    public void affectUserToProfile(Map<String, String> user, String profileId, Map<String, Object> jsParameters) {
        try {
            if (this._profileAssignmentStorageEP == null) {
                this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)this._sManager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
            }
            if (this._rightCtxEP == null) {
                this._rightCtxEP = (RightAssignmentContextExtensionPoint)this._sManager.lookup(RightAssignmentContextExtensionPoint.ROLE);
            }
        }
        catch (ServiceException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<Object> rootContexts = new ArrayList<Object>();
        for (String id : this._rightCtxEP.getExtensionsIds()) {
            RightAssignmentContext rightAssignmentContext = (RightAssignmentContext)this._rightCtxEP.getExtension(id);
            rootContexts.addAll(rightAssignmentContext.getRootContexts(this.getContextualParameters(jsParameters)));
        }
        UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
        for (Object e : rootContexts) {
            this._profileAssignmentStorageEP.removeDeniedProfileFromUser(userIdentity, profileId, e);
            this._profileAssignmentStorageEP.allowProfileToUser(userIdentity, profileId, e);
        }
    }

    @Callable
    public String affectUserToNewProfile(Map<String, String> user, String newProfileName, Map<String, Object> jsParameters) {
        try {
            if (this._rightsEP == null) {
                this._rightsEP = (RightsExtensionPoint)this._sManager.lookup(RightsExtensionPoint.ROLE);
            }
            if (this._profilesDAO == null) {
                this._profilesDAO = (RightProfilesDAO)this._sManager.lookup(RightProfilesDAO.ROLE);
            }
        }
        catch (ServiceException e) {
            throw new IllegalStateException(e);
        }
        Profile newSuperProfile = this._profilesDAO.addProfile(newProfileName, null);
        this._profilesDAO.addRights(newSuperProfile, new ArrayList<String>(this._rightsEP.getExtensionsIds()));
        this.affectUserToProfile(user, newSuperProfile.getId(), jsParameters);
        return newSuperProfile.getId();
    }

    protected Map<String, Object> getContextualParameters(Map<String, Object> jsParameters) {
        HashMap<String, Object> contextParameters = new HashMap<String, Object>(jsParameters);
        String workspaceName = (String)this._script.getParameters().get("workspaceName");
        contextParameters.put("workspaceName", workspaceName);
        return contextParameters;
    }
}

