/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.servlet;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeConfig {
    private static RuntimeConfig __config;
    private boolean _safeMode;
    private String _defaultWorkspace;
    private String _initClass;
    private final Collection<String> _pluginsLocations = new ArrayList<String>();
    private final Collection<String> _excludedPlugins = new ArrayList<String>();
    private final Collection<String> _excludedFeatures = new ArrayList<String>();
    private final Collection<String> _excludedWorkspaces = new ArrayList<String>();
    private final Map<String, String> _overridenThemes = new HashMap<String, String>();
    private final Map<String, String> _components = new HashMap<String, String>();
    private Logger _logger = LoggerFactory.getLogger(RuntimeConfig.class);
    private String _contextPath;
    private String _version;
    private Date _buildDate;
    private File _externalKernel;
    private Map<String, File> _externalPlugins = new HashMap<String, File>();
    private Map<String, File> _externalWorkspaces = new HashMap<String, File>();
    private File _ametysHome;

    private RuntimeConfig() {
    }

    public static RuntimeConfig getInstance() {
        if (__config == null) {
            throw new IllegalStateException("RuntimeConfig has not been initialized.");
        }
        return __config;
    }

    public static boolean isConfigured() {
        return __config != null;
    }

    public static synchronized void configure(Configuration runtimeConf, Configuration externalConf, File ametysHome, String contextPath) {
        __config = new RuntimeConfig();
        RuntimeConfig.__config._contextPath = contextPath;
        RuntimeConfig.__config._ametysHome = ametysHome;
        File dataHome = new File(ametysHome, "data");
        dataHome.mkdirs();
        File configHome = new File(ametysHome, "config");
        configHome.mkdirs();
        File tmpDir = new File(ametysHome, "tmp");
        tmpDir.mkdirs();
        if (runtimeConf != null) {
            RuntimeConfig.__config._safeMode = false;
            RuntimeConfig.__config._initClass = runtimeConf.getChild("initClass").getValue(null);
            __config._configureWorkspaces(runtimeConf.getChild("workspaces"));
            __config._configurePlugins(runtimeConf.getChild("plugins"));
            __config._configureComponents(runtimeConf.getChild("components"));
            __config._configureApplication(runtimeConf.getChild("application"));
        } else {
            RuntimeConfig.__config._safeMode = true;
            RuntimeConfig.__config._pluginsLocations.add("plugins/");
        }
        if (externalConf != null) {
            __config._configureExternal(externalConf);
        }
    }

    private void _configureWorkspaces(Configuration config) {
        String workspace;
        this._defaultWorkspace = config.getAttribute("default", null);
        for (Configuration excluded : config.getChild("exclude").getChildren("workspace")) {
            workspace = excluded.getValue(null);
            if (workspace == null) continue;
            this._excludedWorkspaces.add(workspace);
        }
        for (Configuration theme : config.getChild("theme").getChildren("workspace")) {
            workspace = theme.getAttribute("name", null);
            String newTheme = theme.getValue(null);
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{workspace, newTheme})) continue;
            this._overridenThemes.put(workspace, newTheme);
        }
    }

    private void _configurePlugins(Configuration config) {
        for (Configuration excluded : config.getChild("exclude").getChildren("plugin")) {
            String plugin = excluded.getValue(null);
            if (plugin == null) continue;
            this._excludedPlugins.add(plugin);
        }
        for (Configuration excluded : config.getChild("exclude").getChildren("feature")) {
            String feature = excluded.getValue(null);
            if (feature == null) continue;
            this._excludedFeatures.add(feature);
        }
        for (Configuration locationConf : config.getChild("locations").getChildren("location")) {
            String location = locationConf.getValue(null);
            if (location == null) continue;
            this._pluginsLocations.add(location);
        }
        if (!this._pluginsLocations.contains("plugins") && !this._pluginsLocations.contains("plugins/")) {
            this._pluginsLocations.add("plugins/");
        }
    }

    private void _configureComponents(Configuration config) {
        for (Configuration extension : config.getChildren()) {
            String point = extension.getName();
            String id = extension.getValue(null);
            if (id == null) continue;
            RuntimeConfig.__config._components.put(point, id);
        }
    }

    private void _configureApplication(Configuration config) {
        String strDate;
        String version = config.getChild("version").getValue("");
        if (!"@VERSION@".equals(version) && !"VERSION".equals(version)) {
            this._version = version;
        }
        if (!((strDate = config.getChild("date").getValue(null)) == null || "".equals(strDate) || "@DATE@".equals(strDate) || "DATE".equals(strDate))) {
            try {
                this._buildDate = new SimpleDateFormat("yyyyMMdd'T'HHmm z").parse(strDate);
            }
            catch (ParseException e) {
                this._logger.warn("Unable to parse date '" + strDate + "' with format \"yyyyMMdd'T'HHmm z\". It will be ignored.");
            }
        }
    }

    private void _configureExternal(Configuration config) {
        String location;
        String name;
        String externalKernel = config.getChild("kernel").getValue(null);
        this._externalKernel = this._getFile(externalKernel);
        for (Configuration pluginConf : config.getChild("plugins").getChildren("plugin")) {
            name = pluginConf.getAttribute("name", null);
            location = pluginConf.getValue(null);
            if (name == null || location == null) continue;
            this._externalPlugins.put(name, this._getFile(location));
        }
        for (Configuration workspaceConf : config.getChild("workspaces").getChildren("workspace")) {
            name = workspaceConf.getAttribute("name", null);
            location = workspaceConf.getValue(null);
            if (location == null) continue;
            this._externalWorkspaces.put(name, this._getFile(location));
        }
    }

    private File _getFile(String path) {
        File file;
        File file2 = file = path == null ? null : new File(path);
        File result = file == null ? null : (file.isAbsolute() ? file : new File(this._contextPath, path));
        return result;
    }

    public boolean isSafeMode() {
        return this._safeMode;
    }

    public String getDefaultWorkspace() {
        return this._defaultWorkspace;
    }

    public String getInitClassName() {
        return this._initClass;
    }

    public Collection<String> getPluginsLocations() {
        return this._pluginsLocations;
    }

    public Map<String, File> getExternalPlugins() {
        return this._externalPlugins;
    }

    public Map<String, File> getExternalWorkspaces() {
        return this._externalWorkspaces;
    }

    public File getExternalKernel() {
        return this._externalKernel;
    }

    public Collection<String> getExcludedPlugins() {
        return this._excludedPlugins;
    }

    public Collection<String> getExcludedFeatures() {
        return this._excludedFeatures;
    }

    public Collection<String> getExcludedWorkspaces() {
        return this._excludedWorkspaces;
    }

    public Map<String, String> getOverridenThemes() {
        return this._overridenThemes;
    }

    public Map<String, String> getComponents() {
        return this._components;
    }

    public String getApplicationVersion() {
        return this._version;
    }

    public Date getApplicationBuildDate() {
        return this._buildDate;
    }

    public File getAmetysHome() {
        return this._ametysHome;
    }
}

