<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="kernel://pages/home/home.xsl"/>
   	<xsl:import href="workspace:admin://pages/common/common.xsl"/>
   	<xsl:import href="template.xsl"/>
   	
    <xsl:param name="debug-mode">true</xsl:param>
    
    <xsl:param name="contextPath"/>
    <xsl:param name="workspaceName"/>
    <xsl:param name="workspaceURI"/>
    
    <xsl:variable name="workspaceContext"><xsl:value-of select="$contextPath"/><xsl:value-of select="$workspaceURI"/></xsl:variable>
    
    <xsl:template match="/">
        <xsl:call-template name="home">
            <xsl:with-param name="needs-kernel-ui" select="true()"/>
            <xsl:with-param name="debug-mode">true</xsl:with-param>
            
            <xsl:with-param name="context-path" select="$contextPath"/>
            <xsl:with-param name="workspace-name" select="$workspaceName"/>
            <xsl:with-param name="workspace-prefix" select="$workspaceURI"/>
            
            <xsl:with-param name="plugins-direct-prefix">/plugins</xsl:with-param>
            <xsl:with-param name="plugins-wrapped-prefix">/_plugins</xsl:with-param>
            
            <xsl:with-param name="authorized-browsers"><xsl:call-template name="authorized-browsers"/></xsl:with-param>
            
            <xsl:with-param name="head-title"><xsl:call-template name="head-title"/></xsl:with-param>
            
            <xsl:with-param name="head-meta">
                <xsl:call-template name="head-meta"/>
                <xsl:call-template name="workspace-scripts"/>
                <xsl:call-template name="common-script"/>
            </xsl:with-param>
            
            <xsl:with-param name="body-title"><xsl:call-template name="body-title"/></xsl:with-param>
            
            <xsl:with-param name="body-col-main">
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Override common.xsl -->
    <xsl:template name="head-title">
        <i18n:text i18n:catalogue="workspace.{$workspaceName}" i18n:key="WORKSPACE_REPOSITORY_LABEL_SHORT"/>
    </xsl:template>
    
    <!-- +
         | Returns value for the home template, parameter body-title
         | @private
         + -->
    <!-- Override common.xsl -->
    <xsl:template name="body-title">
        <img id="title-logo" alt="workspace.{$workspaceName}:WORKSPACE_REPOSITORY_LABEL_SHORT" i18n:attr="alt"/>
        <script type="text/javascript">
            document.getElementById('title-logo').src = "<xsl:value-of select="$contextPath"/><xsl:value-of select="$workspaceURI"/>/resources/img/repository-header-<i18n:text i18n:key="KERNEL_LANGUAGE_CODE" i18n:catalogue="kernel"/>.png";
        </script>
    </xsl:template>
    
    <xsl:template name="workspace-scripts">
        <script type="text/javascript">var workspaceURI = "<xsl:value-of select="$workspaceURI"/>";</script>
        <script type="text/javascript">var contextPath = "<xsl:value-of select="$contextPath"/>";</script>
        
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/utils/Tooltip.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/utils/Utils.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/HomePage.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/RepositoryActions.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/tree/SearchTreePanel.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/tree/JCRTreePanel.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/PropertiesPanel.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/JCRViewTab.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/AdminTab.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}{$workspaceURI}/resources/js/Ametys/workspace/repository/ConsoleTab.i18n.js"><xsl:comment>//empty</xsl:comment></script>
        
        <script type="text/javascript" src="{$contextPath}/plugins/codemirror/resources/js/codemirror.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}/plugins/codemirror/resources/js/addon/edit/matchbrackets.js"><xsl:comment>//empty</xsl:comment></script>
        <script type="text/javascript" src="{$contextPath}/plugins/codemirror/resources/js/addon/selection/active-line.js"><xsl:comment>//empty</xsl:comment></script>
        
        <script type="text/javascript" src="{$contextPath}/plugins/codemirror/resources/js/mode/javascript/javascript.js"><xsl:comment>//empty</xsl:comment></script>
        
        <link rel="stylesheet" type="text/css" href="{$contextPath}/plugins/codemirror/resources/css/codemirror.css" />
        
        <style>
            .CodeMirror {
                line-height: 1.25em;
            }
            
            /* Fix incompatibility ExtJS 4 and CodeMirror 3 (double bottom scrollers) */
            .x-border-box .CodeMirror, .x-border-box .CodeMirror * {
                -moz-box-sizing: content-box;
            }
            
            .CodeMirror-activeline-background {
    			background: none repeat scroll 0 0 #E8F2FF;
			}
        </style>
        
        <xsl:comment>[if IE]&gt;
            &lt;style&gt;
                .CodeMirror {
                    font-size: 1em !important;
                    line-height: 1em !important;
                }
            &lt;/style&gt;
            &lt;![endif]</xsl:comment>
                
        <xsl:call-template name="kernel-load">
            <xsl:with-param name="scripts" select="/Workspace/views/view/scripts/file"/>
            <xsl:with-param name="css" select="/Workspace/views/view/css/file"/>
            <xsl:with-param name="context-path" select="$contextPath"/>
        </xsl:call-template>
        
        <script type="text/javascript">
            var customTabs = [
            <xsl:for-each select="/Workspace/views/view/action">
                <xsl:if test="position() &gt; 1">
                    <xsl:text>,
</xsl:text></xsl:if>
                <xsl:text>'</xsl:text>
                <xsl:value-of select="@class"/>
                <xsl:text>'</xsl:text>
            </xsl:for-each>
            ];
        </script>
    </xsl:template>
    
</xsl:stylesheet>
