<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	
    <xsl:param name="contextPath"/>
    <xsl:param name="workspaceName"/>
    <xsl:param name="workspaceURI"/>
    
    <xsl:variable name="workspaceContext"><xsl:value-of select="$contextPath"/><xsl:value-of select="$workspaceURI"/></xsl:variable>
    
    <!-- +
         | Returns value for the home template, parameter head-meta
         | @private
         + -->
    <xsl:template name="head-meta">
        <link rel="stylesheet" href="{$contextPath}/_admin/resources/css/common/common.css" type="text/css"/>
        <link rel="stylesheet" href="{$contextPath}{$workspaceURI}/resources/css/home.css" type="text/css"/>
<!--         <xsl:call-template name="common-script"/> -->
    </xsl:template> 
    
    <!-- +
         | Creates a script tag to initialize ExtJs in the center panel of the home template.
         | You have to have a createTop js function that will be called to the top part of the main part of the screen
         | You have to have a createPanel js function that will be called to fill the center
         | You have to have a createDock js function that will be called after
         | @private
         + -->
    <xsl:template name="common-script">
        <script type="text/javascript">
            function redirect(plugin, params) {
                function _checkLink (link)
                {
                    if (link.substring(0, 1) != '/')
                    {
                        link = '/' + link;
                    }
                    return link;
                }
                
                window.location.href = Ametys.getPluginWrapperPrefix(plugin) + _checkLink(params.Link);
            }
            
            createTop = function ()
            {
                return null;
            }
            
            function createDock() {};
            
            createPanel = Ametys.workspace.repository.HomePage.createPanel;
            createBottom = function(){};
            
            Ext.application({
                name: 'Ametys',
                
                launch: function() {
                    var items = [];
                        var toping = createTop();
                        if (toping != null)
                        {
                            items.push(Ext.apply(toping, {region: 'north'}));
                        }
                        items.push(Ext.apply(createPanel(), {region: 'center'}));
                    
                    var mainPanel = Ext.create('Ext.panel.Panel', {
                        scrollable: false,
                        border: false,
                        bodyCls: 'admin-main-panel',
                        layout: 'border',
                        
                        items: items,
                        
                        listeners: {
                            'render' : function() {
                                this.setSize(Ext.get('main').getSize(true))
                            }
                        },
                        renderTo: 'main'
                    });
                    
                    Ext.EventManager.onWindowResize(function() {
                        this.setSize(null, 0);
                        this.setSize(Ext.get('main').getSize(true))
                    }, mainPanel);
                    
                    createDock();
                    
                    createBottom();
                    
                    if (typeof appReady == "function")
                    {
                        appReady();
                    }
                }
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>
