/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a repeater container
 * @private
 */
Ext.define('Ametys.form.ConfigurableFormPanel.Repeater2018',
{
    extend: 'Ametys.form.ConfigurableFormPanel.Repeater',
    
    /**
     * @cfg {String} defaultPathSeparator='/' The default separator for fields
     */
    defaultPathSeparator: '/',
    
    /**
     * Retrieves the name of the repeater at the given index
     * @param {Number} index The index
     * @return The name of the repeater at the given index
     * @private
     */
    _getNameAtIndex: function(index)
    {
        return this.name + '[' + index + ']';
    }
});
