/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button for enabling/disabling a user population.
 * @private
 */
Ext.define('Ametys.plugins.coreui.populations.EnablePopulationButtonController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * Listener when the content has been modified
     * Will update the state of the buttons effectively upon the current selection.
     * @param {Ametys.message.Message} message The modified message.
     * @protected
     */
    _onModified: function (message)
    {
        this.refresh();
    },
    
    updateState: function()
    {
        this.disable();
        
        var populationId = this.getMatchingTargets()[0].getParameters().id;
        Ametys.plugins.core.populations.UserPopulationDAO.isEnabled([populationId], this._isEnabledCb, {scope: this, refreshing: true});
    },
    
    _updateMatchingSelectionTargets: function()
    {
        // Some task are not deactivatable
        this.setIconDecorator(null);
        
        this.callParent(arguments);
    },
    
    /**
     * @private
     * Callback function invoked after getting the population state
     * @param {Object} response The server response
     * @param {String} response.error if an error occurred
     * @param {Boolean} response.eanbled if the current population target is activated
     */
    _isEnabledCb: function(response)
    {
        if (response.error)
        {
            this.setDescription("{{i18n PLUGINS_CORE_UI_USER_POPULATIONS_ENABLE_DESCRIPTION_ERROR}}");
            this.setIconDecorator(null);
            this.disable();
            this.toggle(false);
        }
        else
        {
            this.setDescription(response.enabled ? "{{i18n PLUGINS_CORE_UI_USER_POPULATIONS_DISABLE_DESCRIPTION}}" : "{{i18n PLUGINS_CORE_UI_USER_POPULATIONS_ENABLE_DESCRIPTION}}");
            this.setIconDecorator(response.enabled ? this.getInitialConfig("enabled-icon-decorator") : this.getInitialConfig("disabled-icon-decorator"));
            this.setIconDecoratorType(response.enabled ? this.getInitialConfig("enabled-icon-decorator-type") : this.getInitialConfig("disabled-icon-decorator-type"));
            this.toggle(response.enabled);
            this.enable();
        }
    }
    
});