/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the abstract class for all glyph sources used in {@link Ametys.form.widget.Illustration} widget.<br>
 * Implement the #getBtnConfig, #getMenuItemConfig, #getCSSFiles and #handler methods in your implementation. 
 * 
 * Do not forgot to register your class in {@link Ametys.form.widget.Illustration} widget as the sample below:
 * 
 * 		Ametys.form.widget.Illustration.registerGlyphSource ('MyType', MyTypeClass);
 * 
 */
Ext.define('Ametys.form.widget.Illustration.GlyphSource', {
	
    /**
     * Get the id of this source
     * @return {String} The id of this source
     * @template
     */
    getId: function()
    {
        throw new Error("The method #getId is not implemented in " + this.self.getName());
    },
    
	/**
	 * Get the button configuration
	 * @param {Object} config The widget initial configuration
	 * @template
	 */
	getBtnConfig: function (config)
	{
		throw new Error("The method #getBtnConfig is not implemented in " + this.self.getName());
	},
	
	/**
	 * Get the menu item configuration
	 * @param {Object} config The widget initial configuration
	 * @template
	 */
	getMenuItemConfig: function (config)
	{
		throw new Error("The method #getMenuItemConfig is not implemented in " + this.self.getName());
	},
	
	/**
	 * Get CSS files
	 * @param {Function} callback The callback function to invoked after getting the CSS files
     * @param {String[]} callback.cssFiles The retrieved CSS files
	 * @template
	 */
	getCSSFiles: function (callback)
    {
    	throw new Error("The method #getCSSFiles is not implemented in " + this.self.getName());
    },
	
	/**
	 * Function called when button or menu item is pressed.
	 * @param {Object} config The widget initial configuration
	 * @param {Function} callback The callback function.
     * @template
	 */
	handler: function (config, callback)
    {
		throw new Error("The method #handler is not implemented in " + this.self.getName());
    },
    
    /**
     * Function called to determines if the source contains glyphes
     * @param {Function} callback The callback function to call with the following parameter:
     * @param {Boolean} callback.available true if the source contains glyphes.
     * @template
     */
    isAvailable: function(callback)
    {
        throw new Error("The method #isAvailable is not implemented in " + this.self.getName());
    }
    
});

