/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This UI helper provides a dialog box to choose a 'application' glyph.
 * See #open method.
 */
Ext.define('Ametys.helper.ChooseApplicationGlyph', {
	singleton: true,
	
	/**
     * Configure and open the dialog box
     * @param {Object} config The configuration options :
     * @param {String} [config.iconCls] The CSS class for the icon of the dialog box.
     * @param {String} [config.title] The title of the dialog box.
     * @param {String} [config.helpMessage] The help message to display on top of dialog box.
     * @param {Function} config.callback The callback function invoked when a glyph is selected. The callback function will received the following parameters:
     * @param {Object} config.callback.glyph The name of selected glyph
     */
	open: function (config)
	{
        config = Ext.apply(config, {
            storeCfg: {
                proxy: {
                            type: 'ametys',
                            plugin: 'core-ui',
                            role: 'org.ametys.plugins.core.ui.glyph.ApplicationGlyphManager',
                            methodName: 'getGlyphsStore',
                            methodArguments: [],
                            reader: {
                                type: 'json'
                            }
                        }
            }
        });
        
        Ametys.helper.ChooseGlyph.open(config);
	}
});

