/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private JEditorPane textArea;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public HTMLLicencePanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        Serializable serializable;
        this.loadLicence();
        this.add((Component)LabelFactory.create(installerFrame.langpack.getString("LicencePanel.info"), installerFrame.icons.getImageIcon("history"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            serializable = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            this.add((Component)serializable, "nextLine");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new ButtonGroup();
        this.yesRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.agree"), false);
        ((ButtonGroup)serializable).add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.notagree"), true);
        ((ButtonGroup)serializable).add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    private URL loadLicence() {
        String string = "HTMLLicencePanel.licence";
        try {
            return ResourceManager.getInstance().getURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        try {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(hyperlinkEvent.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

